<?php
/**
 * Theme Customizer
 *
 * @package Perfect News
 */

function perfect_news_customize_register( $wp_customize ) {

	// Upsell Section.
	$wp_customize->add_section(
		new Perfect_News_Upsell_Section(
			$wp_customize,
			'upsell_sections',
			array(
				'title'            => __( 'Perfect News Pro', 'perfect-news' ),
				'button_text'      => __( 'Buy Pro', 'perfect-news' ),
				'url'              => 'https://ascendoor.com/themes/perfect-news-pro/',
				'background_color' => '#df2e38',
				'text_color'       => '#fff',
				'priority'         => 0,
			)
		)
	);

}
add_action( 'customize_register', 'perfect_news_customize_register' );

function perfect_news_custom_control_scripts() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_style( 'perfect-news-custom-controls-css', get_stylesheet_directory_uri() . '/assets/css/custom-controls' . $min . '.css', array( 'ascendoor-news-custom-controls-css' ), '1.0', 'all' );
	wp_enqueue_script( 'perfect-news-custom-controls-js', get_stylesheet_directory_uri() . '/assets/js/custom-controls' . $min . '.js', array( 'ascendoor-news-custom-controls-js', 'jquery', 'jquery-ui-core' ), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'perfect_news_custom_control_scripts' );
