<?php
/**
 * Perfect News functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Perfect News
 */

if ( ! function_exists( 'perfect_news_setup' ) ) :
	function perfect_news_setup() {
		/*
		* Make child theme available for translation.
		* Translations can be filed in the /languages/ directory.
		*/
		load_child_theme_textdomain( 'perfect-news', get_stylesheet_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'title-tag' );

		add_theme_support( 'register_block_pattern' );

		add_theme_support( 'register_block_style' );

		add_theme_support( 'wp-block-styles' );

		add_theme_support( 'align-wide' );

		add_theme_support( 'responsive-embeds' );
	}
endif;
add_action( 'after_setup_theme', 'perfect_news_setup' );

if ( ! function_exists( 'perfect_news_enqueue_styles' ) ) :
	/**
	 * Enqueue scripts and styles.
	 */
	function perfect_news_enqueue_styles() {
		$parenthandle = 'ascendoor-news-style';
		$theme        = wp_get_theme();

		wp_enqueue_style(
			$parenthandle,
			get_template_directory_uri() . '/style.css',
			array(
				'ascendoor-news-slick-style',
				'ascendoor-news-fontawesome-style',
				'ascendoor-news-google-fonts',
			),
			$theme->parent()->get( 'Version' )
		);

		wp_enqueue_style(
			'perfect-news-style',
			get_stylesheet_uri(),
			array( $parenthandle ),
			$theme->get( 'Version' )
		);

	}

endif;

add_action( 'wp_enqueue_scripts', 'perfect_news_enqueue_styles' );

function perfect_news_body_classes( $classes ) {
	$classes[] = 'artistic-design';
	return $classes;
}
add_filter( 'body_class', 'perfect_news_body_classes' );

function admin_style() {
	?>
	<style type="text/css">
		.ocdi .notice.ascendoor-news-demo-data {
			display: none !important;
		}
	</style>
	<?php
}
add_action( 'admin_enqueue_scripts', 'admin_style' );

require get_theme_file_path() . '/inc/customizer.php';

// Custom Controls.
require get_theme_file_path() . '/inc/custom-controls.php';

// Widgets.
require get_theme_file_path() . '/inc/widgets/widgets.php';

/**
 * One Click Demo Import after import setup.
 */
if ( class_exists( 'OCDI_Plugin' ) ) {
	require get_theme_file_path() . '/inc/ocdi.php';
}
